LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY dff IS
  PORT( CLK, din : IN std_logic;
        Q, QB : OUT std_logic);
BEGIN
  PROCESS(CLK, din)
    VARIABLE last_d_change : TIME := 0 ns;
    VARIABLE last_clk, last_d_value : std_logic := 'X';
  BEGIN
    IF (din /= last_d_value) THEN
      last_d_change := now;
      last_d_value := din;
    END IF;

    IF (CLK /= last_clk) THEN
      IF  (CLK = '1') THEN
        ASSERT(now - last_d_change >= 15 ns)
          REPORT "setup error"
          SEVERITY ERROR;
      END IF;

      last_clk := CLK;
    END IF;
  END PROCESS;
END dff;

ARCHITECTURE behave OF dff IS
BEGIN

END behave;

ARCHITECTURE struct OF dff IS
BEGIN

END struct;

ARCHITECTURE switch OF dff IS
BEGIN

END switch; 



